/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.mac.MacVirtualMemory;
import oshi.jna.ByRef;
import oshi.jna.Struct;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;

@ThreadSafe
final class MacGlobalMemory
extends AbstractGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacGlobalMemory.class);
    private final Supplier<Long> available = Memoizer.memoize(this::queryVmStats, Memoizer.defaultExpiration());
    private final Supplier<Long> total = Memoizer.memoize(MacGlobalMemory::queryPhysMem);
    private final Supplier<Long> pageSize = Memoizer.memoize(MacGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    MacGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.available.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    @Override
    public List<PhysicalMemory> getPhysicalMemory() {
        ArrayList<PhysicalMemory> arrayList = new ArrayList<PhysicalMemory>();
        List<String> list = ExecutingCommand.runNative("system_profiler SPMemoryDataType");
        int n = 0;
        String string = "unknown";
        long l = 0L;
        long l2 = 0L;
        String string2 = "unknown";
        String string3 = "unknown";
        for (String string4 : list) {
            String[] stringArray;
            if (string4.trim().startsWith("BANK")) {
                int n2;
                if (n++ > 0) {
                    arrayList.add(new PhysicalMemory(string, l, l2, string2, string3));
                }
                if ((n2 = (string = string4.trim()).lastIndexOf(58)) <= 0) continue;
                string = string.substring(0, n2 - 1);
                continue;
            }
            if (n <= 0 || (stringArray = string4.trim().split(":")).length != 2) continue;
            switch (stringArray[0]) {
                case "Size": {
                    l = ParseUtil.parseDecimalMemorySizeToBinary(stringArray[1].trim());
                    break;
                }
                case "Type": {
                    string3 = stringArray[1].trim();
                    break;
                }
                case "Speed": {
                    l2 = ParseUtil.parseHertz(stringArray[1]);
                    break;
                }
                case "Manufacturer": {
                    string2 = stringArray[1].trim();
                    break;
                }
            }
        }
        arrayList.add(new PhysicalMemory(string, l, l2, string2, string3));
        return arrayList;
    }

    private long queryVmStats() {
        try (Struct.CloseableVMStatistics closeableVMStatistics = new Struct.CloseableVMStatistics();){
            ByRef.CloseableIntByReference closeableIntByReference;
            block12: {
                closeableIntByReference = new ByRef.CloseableIntByReference(closeableVMStatistics.size() / SystemB.INT_SIZE);
                try {
                    if (0 == SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, closeableVMStatistics, closeableIntByReference)) break block12;
                    LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
                    long l = 0L;
                    closeableIntByReference.close();
                    return l;
                }
                catch (Throwable throwable) {
                    try {
                        closeableIntByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l = (long)(closeableVMStatistics.free_count + closeableVMStatistics.inactive_count) * this.getPageSize();
            closeableIntByReference.close();
            return l;
        }
    }

    private static long queryPhysMem() {
        return SysctlUtil.sysctl("hw.memsize", 0L);
    }

    private static long queryPageSize() {
        try (ByRef.CloseableLongByReference closeableLongByReference = new ByRef.CloseableLongByReference();){
            if (0 == SystemB.INSTANCE.host_page_size(SystemB.INSTANCE.mach_host_self(), closeableLongByReference)) {
                long l = closeableLongByReference.getValue();
                return l;
            }
        }
        LOG.error("Failed to get host page size. Error code: {}", (Object)Native.getLastError());
        return 4098L;
    }

    private VirtualMemory createVirtualMemory() {
        return new MacVirtualMemory(this);
    }
}

