/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.Locale;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.jna.ByRef;
import oshi.jna.platform.unix.FreeBsdLibc;

@ThreadSafe
final class FreeBsdSensors
extends AbstractSensors {
    FreeBsdSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        return FreeBsdSensors.queryKldloadCoretemp();
    }

    private static double queryKldloadCoretemp() {
        String string = "dev.cpu.%d.temperature";
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)FreeBsdLibc.INT_SIZE);){
            int n = 0;
            double d = 0.0;
            try (Memory memory = new Memory(closeableSizeTByReference.longValue());){
                while (0 == FreeBsdLibc.INSTANCE.sysctlbyname(String.format(Locale.ROOT, string, n), memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                    d += (double)memory.getInt(0L) / 10.0 - 273.15;
                    ++n;
                }
            }
            double d2 = n > 0 ? d / (double)n : Double.NaN;
            return d2;
        }
    }

    @Override
    public int[] queryFanSpeeds() {
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        return 0.0;
    }
}

