/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.io.IOException;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import pro.gravit.launcher.paSTELic_lEGAcY;
import pro.gravit.launcher.request.websockets.ClientJSONPoint$1;
import pro.gravit.launcher.request.websockets.WebSocketClientHandler;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoopGroup;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioSocketChannel;
import pro.gravit.repackage.io.netty.handler.codec.http.EmptyHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.handler.ssl.SslContext;
import pro.gravit.repackage.io.netty.handler.ssl.SslContextBuilder;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientJSONPoint {
    private static final AtomicInteger counter = new AtomicInteger();
    private static final ThreadFactory threadFactory = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName(String.format("Netty Thread #%d", counter.incrementAndGet()));
        thread.setDaemon(true);
        return thread;
    };
    private static final EventLoopGroup group = new NioEventLoopGroup(threadFactory);
    private static boolean isCertificatePinning = false;
    protected final Bootstrap bootstrap = new Bootstrap();
    private final URI uri;
    public boolean isClosed;
    protected Channel ch;
    protected WebSocketClientHandler webSocketClientHandler;
    protected boolean ssl = false;
    protected int port;

    public ClientJSONPoint(String string) {
        this(URI.create(string));
    }

    public ClientJSONPoint(URI uRI) {
        SslContext sslContext;
        this.uri = uRI;
        String string = uRI.getScheme();
        if (!"ws".equals(string) && !"wss".equals(string)) {
            throw new IllegalArgumentException("Unsupported protocol: " + string);
        }
        if ("wss".equals(string)) {
            this.ssl = true;
        }
        this.port = uRI.getPort() == -1 ? ("ws".equals(string) ? 80 : 443) : uRI.getPort();
        if (this.ssl) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            if (isCertificatePinning) {
                try {
                    sslContextBuilder.trustManager(paSTELic_lEGAcY.paSTELic_lEGAcY());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                    LogHelper.error(exception);
                    sslContextBuilder.trustManager(new X509Certificate[0]);
                }
            }
            sslContext = sslContextBuilder.build();
        } else {
            sslContext = null;
        }
        ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new ClientJSONPoint$1(this, sslContext, uRI));
    }

    public void open() {
        this.webSocketClientHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, null, false, EmptyHttpHeaders.INSTANCE, 12800000), this);
        this.ch = this.bootstrap.connect(this.uri.getHost(), this.port).sync().channel();
        this.webSocketClientHandler.handshakeFuture().sync();
    }

    public void openAsync(Runnable runnable, Consumer<Throwable> consumer) {
        this.webSocketClientHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, null, false, EmptyHttpHeaders.INSTANCE, 12800000), this);
        ChannelFuture channelFuture = this.bootstrap.connect(this.uri.getHost(), this.port);
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future2 -> {
            if (future2.isSuccess()) {
                this.ch = channelFuture.channel();
                this.webSocketClientHandler.handshakeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    if (future.isSuccess()) {
                        runnable.run();
                    } else {
                        consumer.accept(this.webSocketClientHandler.handshakeFuture().cause());
                    }
                }));
            } else {
                consumer.accept(channelFuture.cause());
            }
        }));
    }

    public void send(String string) {
        LogHelper.dev("Send: %s", string);
        this.ch.writeAndFlush(new TextWebSocketFrame(string), this.ch.voidPromise());
    }

    abstract void onMessage(String var1);

    abstract void onDisconnect();

    abstract void onOpen();

    public void close() {
        this.isClosed = true;
        if (this.ch != null && this.ch.isActive()) {
            this.ch.writeAndFlush(new CloseWebSocketFrame(), this.ch.voidPromise());
            this.ch.closeFuture().sync();
        }
        group.shutdownGracefully();
    }

    public void eval(String string) {
        this.ch.writeAndFlush(new TextWebSocketFrame(string), this.ch.voidPromise());
    }
}

