/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.oio;

import java.io.IOException;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelMetadata;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.FileRegion;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator$Handle;
import pro.gravit.repackage.io.netty.channel.oio.AbstractOioChannel;
import pro.gravit.repackage.io.netty.channel.socket.ChannelInputShutdownEvent;
import pro.gravit.repackage.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';

    protected AbstractOioByteChannel(Channel channel) {
        super(channel);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean isInputShutdown();

    protected abstract ChannelFuture shutdownInput();

    private void closeOnRead(ChannelPipeline channelPipeline) {
        if (this.isOpen()) {
            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                this.shutdownInput();
                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.unsafe().close(this.unsafe().voidPromise());
            }
            channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        recvByteBufAllocator$Handle.readComplete();
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl || throwable instanceof OutOfMemoryError || throwable instanceof IOException) {
            this.closeOnRead(channelPipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead() {
        ChannelConfig channelConfig = this.config();
        if (this.isInputShutdown() || !this.readPending) {
            return;
        }
        this.readPending = false;
        ChannelPipeline channelPipeline = this.pipeline();
        ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.reset(channelConfig);
        ByteBuf byteBuf = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
            do {
                int n;
                recvByteBufAllocator$Handle.lastBytesRead(this.doReadBytes(byteBuf));
                if (recvByteBufAllocator$Handle.lastBytesRead() <= 0) {
                    if (byteBuf.isReadable()) break;
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl3 = bl = recvByteBufAllocator$Handle.lastBytesRead() < 0;
                    if (!bl) break;
                    this.readPending = false;
                    break;
                }
                bl2 = true;
                int n2 = this.available();
                if (n2 <= 0) break;
                if (byteBuf.isWritable()) continue;
                int n3 = byteBuf.capacity();
                if (n3 == (n = byteBuf.maxCapacity())) {
                    recvByteBufAllocator$Handle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
                    continue;
                }
                int n4 = byteBuf.writerIndex();
                if (n4 + n2 > n) {
                    byteBuf.capacity(n);
                    continue;
                }
                byteBuf.ensureWritable(n2);
            } while (recvByteBufAllocator$Handle.continueReading());
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
                byteBuf = null;
            }
            if (bl2) {
                recvByteBufAllocator$Handle.readComplete();
                channelPipeline.fireChannelReadComplete();
            }
            if (bl) {
                this.closeOnRead(channelPipeline);
            }
        }
        catch (Throwable throwable) {
            this.handleReadException(channelPipeline, byteBuf, throwable, bl, recvByteBufAllocator$Handle);
        }
        finally {
            if (this.readPending || channelConfig.isAutoRead() || !bl2 && this.isActive()) {
                this.read();
            }
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCounted referenceCounted;
            if (object instanceof ByteBuf) {
                referenceCounted = (ByteBuf)object;
                int n = ((ByteBuf)referenceCounted).readableBytes();
                while (n > 0) {
                    this.doWriteBytes((ByteBuf)referenceCounted);
                    int n2 = ((ByteBuf)referenceCounted).readableBytes();
                    channelOutboundBuffer.progress(n - n2);
                    n = n2;
                }
                channelOutboundBuffer.remove();
                continue;
            }
            if (object instanceof FileRegion) {
                referenceCounted = (FileRegion)object;
                long l = referenceCounted.transferred();
                this.doWriteFileRegion((FileRegion)referenceCounted);
                channelOutboundBuffer.progress(referenceCounted.transferred() - l);
                channelOutboundBuffer.remove();
                continue;
            }
            channelOutboundBuffer.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object)));
        }
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf || object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1);

    protected abstract void doWriteBytes(ByteBuf var1);

    protected abstract void doWriteFileRegion(FileRegion var1);
}

