/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.pool;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.pool.ChannelHealthChecker;
import pro.gravit.repackage.io.netty.channel.pool.ChannelPoolHandler;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$1;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$2;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$3;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$4;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$5;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$6;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$AcquireListener;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$AcquireTask;
import pro.gravit.repackage.io.netty.channel.pool.FixedChannelPool$AcquireTimeoutAction;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GlobalEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class FixedChannelPool
extends SimpleChannelPool {
    private final EventExecutor executor;
    private final long acquireTimeoutNanos;
    private final Runnable timeoutTask;
    private final Queue<FixedChannelPool$AcquireTask> pendingAcquireQueue = new ArrayDeque<FixedChannelPool$AcquireTask>();
    private final int maxConnections;
    private final int maxPendingAcquires;
    private final AtomicInteger acquiredChannelCount = new AtomicInteger();
    private int pendingAcquireCount;
    private boolean closed;

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, int n) {
        this(bootstrap, channelPoolHandler, n, Integer.MAX_VALUE);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, int n, int n2) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE, null, -1L, n, n2);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, FixedChannelPool$AcquireTimeoutAction fixedChannelPool$AcquireTimeoutAction, long l, int n, int n2) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, fixedChannelPool$AcquireTimeoutAction, l, n, n2, true);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, FixedChannelPool$AcquireTimeoutAction fixedChannelPool$AcquireTimeoutAction, long l, int n, int n2, boolean bl) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, fixedChannelPool$AcquireTimeoutAction, l, n, n2, bl, true);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, FixedChannelPool$AcquireTimeoutAction fixedChannelPool$AcquireTimeoutAction, long l, int n, int n2, boolean bl, boolean bl2) {
        super(bootstrap, channelPoolHandler, channelHealthChecker, bl, bl2);
        ObjectUtil.checkPositive(n, "maxConnections");
        ObjectUtil.checkPositive(n2, "maxPendingAcquires");
        if (fixedChannelPool$AcquireTimeoutAction == null && l == -1L) {
            this.timeoutTask = null;
            this.acquireTimeoutNanos = -1L;
        } else {
            if (fixedChannelPool$AcquireTimeoutAction == null && l != -1L) {
                throw new NullPointerException("action");
            }
            if (fixedChannelPool$AcquireTimeoutAction != null && l < 0L) {
                throw new IllegalArgumentException("acquireTimeoutMillis: " + l + " (expected: >= 0)");
            }
            this.acquireTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(l);
            switch (fixedChannelPool$AcquireTimeoutAction) {
                case FAIL: {
                    this.timeoutTask = new FixedChannelPool$1(this);
                    break;
                }
                case NEW: {
                    this.timeoutTask = new FixedChannelPool$2(this);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        this.executor = bootstrap.config().group().next();
        this.maxConnections = n;
        this.maxPendingAcquires = n2;
    }

    public int acquiredChannelCount() {
        return this.acquiredChannelCount.get();
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        try {
            if (this.executor.inEventLoop()) {
                this.acquire0(promise);
            } else {
                this.executor.execute(new FixedChannelPool$3(this, promise));
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
        return promise;
    }

    private void acquire0(Promise<Channel> promise) {
        try {
            assert (this.executor.inEventLoop());
            if (this.closed) {
                promise.setFailure(new IllegalStateException("FixedChannelPool was closed"));
                return;
            }
            if (this.acquiredChannelCount.get() < this.maxConnections) {
                assert (this.acquiredChannelCount.get() >= 0);
                Promise<Channel> promise2 = this.executor.newPromise();
                FixedChannelPool$AcquireListener fixedChannelPool$AcquireListener = new FixedChannelPool$AcquireListener(this, promise);
                fixedChannelPool$AcquireListener.acquired();
                promise2.addListener(fixedChannelPool$AcquireListener);
                super.acquire(promise2);
            } else {
                if (this.pendingAcquireCount >= this.maxPendingAcquires) {
                    this.tooManyOutstanding(promise);
                } else {
                    FixedChannelPool$AcquireTask fixedChannelPool$AcquireTask = new FixedChannelPool$AcquireTask(this, promise);
                    if (this.pendingAcquireQueue.offer(fixedChannelPool$AcquireTask)) {
                        ++this.pendingAcquireCount;
                        if (this.timeoutTask != null) {
                            fixedChannelPool$AcquireTask.timeoutFuture = this.executor.schedule(this.timeoutTask, this.acquireTimeoutNanos, TimeUnit.NANOSECONDS);
                        }
                    } else {
                        this.tooManyOutstanding(promise);
                    }
                }
                assert (this.pendingAcquireCount > 0);
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
    }

    private void tooManyOutstanding(Promise<?> promise) {
        promise.setFailure(new IllegalStateException("Too many outstanding acquire operations"));
    }

    @Override
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        Promise<Void> promise2 = this.executor.newPromise();
        super.release(channel, promise2.addListener(new FixedChannelPool$4(this, channel, promise)));
        return promise;
    }

    private void decrementAndRunTaskQueue() {
        int n = this.acquiredChannelCount.decrementAndGet();
        assert (n >= 0);
        this.runTaskQueue();
    }

    private void runTaskQueue() {
        FixedChannelPool$AcquireTask fixedChannelPool$AcquireTask;
        while (this.acquiredChannelCount.get() < this.maxConnections && (fixedChannelPool$AcquireTask = this.pendingAcquireQueue.poll()) != null) {
            ScheduledFuture<?> scheduledFuture = fixedChannelPool$AcquireTask.timeoutFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            --this.pendingAcquireCount;
            fixedChannelPool$AcquireTask.acquired();
            super.acquire(fixedChannelPool$AcquireTask.promise);
        }
        assert (this.pendingAcquireCount >= 0);
        assert (this.acquiredChannelCount.get() >= 0);
    }

    @Override
    public void close() {
        try {
            this.closeAsync().await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public Future<Void> closeAsync() {
        if (this.executor.inEventLoop()) {
            return this.close0();
        }
        Promise<Void> promise = this.executor.newPromise();
        this.executor.execute(new FixedChannelPool$5(this, promise));
        return promise;
    }

    private Future<Void> close0() {
        assert (this.executor.inEventLoop());
        if (!this.closed) {
            FixedChannelPool$AcquireTask fixedChannelPool$AcquireTask;
            this.closed = true;
            while ((fixedChannelPool$AcquireTask = this.pendingAcquireQueue.poll()) != null) {
                ScheduledFuture<?> scheduledFuture = fixedChannelPool$AcquireTask.timeoutFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                fixedChannelPool$AcquireTask.promise.setFailure(new ClosedChannelException());
            }
            this.acquiredChannelCount.set(0);
            this.pendingAcquireCount = 0;
            return GlobalEventExecutor.INSTANCE.submit((Callable)new FixedChannelPool$6(this));
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    static /* synthetic */ Future access$201(FixedChannelPool fixedChannelPool, Promise promise) {
        return super.acquire(promise);
    }

    static /* synthetic */ void access$300(FixedChannelPool fixedChannelPool, Promise promise) {
        fixedChannelPool.acquire0(promise);
    }

    static /* synthetic */ EventExecutor access$400(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.executor;
    }

    static /* synthetic */ boolean access$500(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.closed;
    }

    static /* synthetic */ void access$600(FixedChannelPool fixedChannelPool) {
        fixedChannelPool.decrementAndRunTaskQueue();
    }

    static /* synthetic */ long access$700(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.acquireTimeoutNanos;
    }

    static /* synthetic */ Queue access$800(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.pendingAcquireQueue;
    }

    static /* synthetic */ int access$906(FixedChannelPool fixedChannelPool) {
        return --fixedChannelPool.pendingAcquireCount;
    }

    static /* synthetic */ void access$1000(FixedChannelPool fixedChannelPool) {
        fixedChannelPool.runTaskQueue();
    }

    static /* synthetic */ AtomicInteger access$1100(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.acquiredChannelCount;
    }

    static /* synthetic */ Future access$1200(FixedChannelPool fixedChannelPool) {
        return fixedChannelPool.close0();
    }

    static /* synthetic */ void access$1301(FixedChannelPool fixedChannelPool) {
        super.close();
    }
}

