/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.base64;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.MessageToMessageEncoder;
import pro.gravit.repackage.io.netty.handler.codec.base64.Base64;
import pro.gravit.repackage.io.netty.handler.codec.base64.Base64Dialect;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean bl) {
        this(bl, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean bl, Base64Dialect base64Dialect) {
        this.dialect = ObjectUtil.checkNotNull(base64Dialect, "dialect");
        this.breakLines = bl;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        list.add(Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), this.breakLines, this.dialect));
    }
}

