/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import java.nio.ByteBuffer;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.codec.compression.ByteBufChecksum;
import pro.gravit.repackage.io.netty.handler.codec.compression.DecompressionException;

final class CompressionUtil {
    private CompressionUtil() {
    }

    static void checkChecksum(ByteBufChecksum byteBufChecksum, ByteBuf byteBuf, int n) {
        byteBufChecksum.reset();
        byteBufChecksum.update(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
        int n2 = (int)byteBufChecksum.getValue();
        if (n2 != n) {
            throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", n2, n));
        }
    }

    static ByteBuffer safeReadableNioBuffer(ByteBuf byteBuf) {
        return CompressionUtil.safeNioBuffer(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    static ByteBuffer safeNioBuffer(ByteBuf byteBuf, int n, int n2) {
        return byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(n, n2) : byteBuf.nioBuffer(n, n2);
    }
}

