/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders$NameValidator;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders$ValueValidator;
import pro.gravit.repackage.io.netty.handler.codec.Headers;
import pro.gravit.repackage.io.netty.handler.codec.ValueConverter;
import pro.gravit.repackage.io.netty.handler.codec.http.CombinedHttpHeaders$CombinedHttpHeadersImpl$1;
import pro.gravit.repackage.io.netty.handler.codec.http.CombinedHttpHeaders$CombinedHttpHeadersImpl$2;
import pro.gravit.repackage.io.netty.handler.codec.http.CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.util.HashingStrategy;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

final class CombinedHttpHeaders$CombinedHttpHeadersImpl
extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl> {
    private static final int VALUE_LENGTH_ESTIMATE = 10;
    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<Object> objectEscaper;
    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<CharSequence> charSequenceEscaper;

    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<Object> objectEscaper() {
        if (this.objectEscaper == null) {
            this.objectEscaper = new CombinedHttpHeaders$CombinedHttpHeadersImpl$1(this);
        }
        return this.objectEscaper;
    }

    private CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<CharSequence> charSequenceEscaper() {
        if (this.charSequenceEscaper == null) {
            this.charSequenceEscaper = new CombinedHttpHeaders$CombinedHttpHeadersImpl$2(this);
        }
        return this.charSequenceEscaper;
    }

    CombinedHttpHeaders$CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator, DefaultHeaders$ValueValidator<CharSequence> defaultHeaders$ValueValidator) {
        super(hashingStrategy, valueConverter, defaultHeaders$NameValidator, 16, defaultHeaders$ValueValidator);
    }

    @Override
    public Iterator<CharSequence> valueIterator(CharSequence charSequence) {
        Iterator<CharSequence> iterator = super.valueIterator(charSequence);
        if (!iterator.hasNext() || CombinedHttpHeaders$CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
            return iterator;
        }
        Iterator<CharSequence> iterator2 = StringUtil.unescapeCsvFields(iterator.next()).iterator();
        if (iterator.hasNext()) {
            throw new IllegalStateException("CombinedHttpHeaders should only have one value");
        }
        return iterator2;
    }

    @Override
    public List<CharSequence> getAll(CharSequence charSequence) {
        List<CharSequence> list = super.getAll(charSequence);
        if (list.isEmpty() || CombinedHttpHeaders$CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
            return list;
        }
        if (list.size() != 1) {
            throw new IllegalStateException("CombinedHttpHeaders should only have one value");
        }
        return StringUtil.unescapeCsvFields(list.get(0));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        if (headers instanceof CombinedHttpHeaders$CombinedHttpHeadersImpl) {
            if (this.isEmpty()) {
                this.addImpl(headers);
            } else {
                for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                    this.addEscapedValue(entry.getKey(), entry.getValue());
                }
            }
        } else {
            for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            return this;
        }
        this.clear();
        return this.add((Headers)headers);
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            return this;
        }
        for (CharSequence charSequence : headers.names()) {
            this.remove(charSequence);
        }
        return this.add(headers);
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence charSequence2) {
        return this.addEscapedValue(charSequence, this.charSequenceEscaper().escape(charSequence, charSequence2));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), charSequenceArray));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), iterable));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object object) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), object));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl addObject(CharSequence charSequence, Iterable<?> iterable) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), iterable));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object ... objectArray) {
        return this.addEscapedValue(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), objectArray));
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl set(CharSequence charSequence, CharSequence ... charSequenceArray) {
        this.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), charSequenceArray));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        this.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.charSequenceEscaper(), iterable));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object object) {
        this.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), object));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object ... objectArray) {
        this.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), objectArray));
        return this;
    }

    @Override
    public CombinedHttpHeaders$CombinedHttpHeadersImpl setObject(CharSequence charSequence, Iterable<?> iterable) {
        this.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparate(charSequence, this.objectEscaper(), iterable));
        return this;
    }

    private static boolean cannotBeCombined(CharSequence charSequence) {
        return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(charSequence);
    }

    private CombinedHttpHeaders$CombinedHttpHeadersImpl addEscapedValue(CharSequence charSequence, CharSequence charSequence2) {
        CharSequence charSequence3 = (CharSequence)this.get(charSequence);
        if (charSequence3 == null || CombinedHttpHeaders$CombinedHttpHeadersImpl.cannotBeCombined(charSequence)) {
            super.add(charSequence, charSequence2);
        } else {
            this.set(charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl.commaSeparateEscapedValues(charSequence3, charSequence2));
        }
        return this;
    }

    private static <T> CharSequence commaSeparate(CharSequence charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<T> combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper, T ... TArray) {
        StringBuilder stringBuilder = new StringBuilder(TArray.length * 10);
        if (TArray.length > 0) {
            int n = TArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(charSequence, TArray[i])).append(',');
            }
            stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(charSequence, TArray[n]));
        }
        return stringBuilder;
    }

    private static <T> CharSequence commaSeparate(CharSequence charSequence, CombinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper<T> combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper, Iterable<? extends T> iterable) {
        StringBuilder stringBuilder = iterable instanceof Collection ? new StringBuilder(((Collection)iterable).size() * 10) : new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            while (iterator.hasNext()) {
                stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(charSequence, t)).append(',');
                t = iterator.next();
            }
            stringBuilder.append(combinedHttpHeaders$CombinedHttpHeadersImpl$CsvValueEscaper.escape(charSequence, t));
        }
        return stringBuilder;
    }

    private static CharSequence commaSeparateEscapedValues(CharSequence charSequence, CharSequence charSequence2) {
        return new StringBuilder(charSequence.length() + 1 + charSequence2.length()).append(charSequence).append(',').append(charSequence2);
    }

    static /* synthetic */ ValueConverter access$000(CombinedHttpHeaders$CombinedHttpHeadersImpl combinedHttpHeaders$CombinedHttpHeadersImpl) {
        return combinedHttpHeaders$CombinedHttpHeadersImpl.valueConverter();
    }
}

