/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.http.CombinedHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessageUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpResponse
extends DefaultHttpResponse
implements FullHttpResponse {
    private final ByteBuf content;
    private final HttpHeaders trailingHeaders;
    private int hash;

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus) {
        this(httpVersion, httpResponseStatus, Unpooled.buffer(0));
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf) {
        this(httpVersion, httpResponseStatus, byteBuf, true);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, boolean bl) {
        this(httpVersion, httpResponseStatus, Unpooled.buffer(0), bl, false);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, boolean bl, boolean bl2) {
        this(httpVersion, httpResponseStatus, Unpooled.buffer(0), bl, bl2);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, boolean bl) {
        this(httpVersion, httpResponseStatus, byteBuf, bl, false);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, boolean bl, boolean bl2) {
        super(httpVersion, httpResponseStatus, bl, bl2);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeaders = bl2 ? new CombinedHttpHeaders(bl) : new DefaultHttpHeaders(bl);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2) {
        super(httpVersion, httpResponseStatus, httpHeaders);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeaders = ObjectUtil.checkNotNull(httpHeaders2, "trailingHeaders");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpResponse retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpResponse retain(int n) {
        this.content.retain(n);
        return this;
    }

    @Override
    public FullHttpResponse touch() {
        this.content.touch();
        return this;
    }

    @Override
    public FullHttpResponse touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int n) {
        return this.content.release(n);
    }

    @Override
    public FullHttpResponse setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public FullHttpResponse setStatus(HttpResponseStatus httpResponseStatus) {
        super.setStatus(httpResponseStatus);
        return this;
    }

    @Override
    public FullHttpResponse copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public FullHttpResponse duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public FullHttpResponse retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullHttpResponse replace(ByteBuf byteBuf) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.protocolVersion(), this.status(), byteBuf, this.headers().copy(), this.trailingHeaders().copy());
        defaultFullHttpResponse.setDecoderResult(this.decoderResult());
        return defaultFullHttpResponse;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            if (ByteBufUtil.isAccessible(this.content())) {
                try {
                    n = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {
                    n = 31;
                }
            } else {
                n = 31;
            }
            n = 31 * n + this.trailingHeaders().hashCode();
            this.hash = n = 31 * n + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpResponse)) {
            return false;
        }
        DefaultFullHttpResponse defaultFullHttpResponse = (DefaultFullHttpResponse)object;
        return super.equals(defaultFullHttpResponse) && this.content().equals(defaultFullHttpResponse.content()) && this.trailingHeaders().equals(defaultFullHttpResponse.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
    }
}

