/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.Attribute;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData$HttpDataType;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DiskAttribute
extends AbstractDiskHttpData
implements Attribute {
    public static String baseDirectory;
    public static boolean deleteOnExitTemporaryFile;
    public static final String prefix = "Attr_";
    public static final String postfix = ".att";
    private String baseDir;
    private boolean deleteOnExit;

    public DiskAttribute(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public DiskAttribute(String string, String string2, boolean bl) {
        this(string, HttpConstants.DEFAULT_CHARSET);
        this.baseDir = string2 == null ? baseDirectory : string2;
        this.deleteOnExit = bl;
    }

    public DiskAttribute(String string, long l) {
        this(string, l, HttpConstants.DEFAULT_CHARSET, baseDirectory, deleteOnExitTemporaryFile);
    }

    public DiskAttribute(String string, long l, String string2, boolean bl) {
        this(string, l, HttpConstants.DEFAULT_CHARSET);
        this.baseDir = string2 == null ? baseDirectory : string2;
        this.deleteOnExit = bl;
    }

    public DiskAttribute(String string, Charset charset) {
        this(string, charset, baseDirectory, deleteOnExitTemporaryFile);
    }

    public DiskAttribute(String string, Charset charset, String string2, boolean bl) {
        super(string, charset, 0L);
        this.baseDir = string2 == null ? baseDirectory : string2;
        this.deleteOnExit = bl;
    }

    public DiskAttribute(String string, long l, Charset charset) {
        this(string, l, charset, baseDirectory, deleteOnExitTemporaryFile);
    }

    public DiskAttribute(String string, long l, Charset charset, String string2, boolean bl) {
        super(string, charset, l);
        this.baseDir = string2 == null ? baseDirectory : string2;
        this.deleteOnExit = bl;
    }

    public DiskAttribute(String string, String string2) {
        this(string, string2, HttpConstants.DEFAULT_CHARSET);
    }

    public DiskAttribute(String string, String string2, Charset charset) {
        this(string, string2, charset, baseDirectory, deleteOnExitTemporaryFile);
    }

    public DiskAttribute(String string, String string2, Charset charset, String string3, boolean bl) {
        super(string, charset, 0L);
        this.setValue(string2);
        this.baseDir = string3 == null ? baseDirectory : string3;
        this.deleteOnExit = bl;
    }

    @Override
    public InterfaceHttpData$HttpDataType getHttpDataType() {
        return InterfaceHttpData$HttpDataType.Attribute;
    }

    @Override
    public String getValue() {
        byte[] byArray = this.get();
        return new String(byArray, this.getCharset());
    }

    @Override
    public void setValue(String string) {
        ObjectUtil.checkNotNull(string, "value");
        byte[] byArray = string.getBytes(this.getCharset());
        this.checkSize(byArray.length);
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        if (this.definedSize > 0L) {
            this.definedSize = byteBuf.readableBytes();
        }
        this.setContent(byteBuf);
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        long l = this.size + (long)byteBuf.readableBytes();
        try {
            this.checkSize(l);
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        if (this.definedSize > 0L && this.definedSize < l) {
            this.definedSize = l;
        }
        super.addContent(byteBuf, bl);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)interfaceHttpData.getHttpDataType()));
        }
        return this.compareTo((Attribute)interfaceHttpData);
    }

    @Override
    public int compareTo(Attribute attribute) {
        return this.getName().compareToIgnoreCase(attribute.getName());
    }

    public String toString() {
        try {
            return this.getName() + '=' + this.getValue();
        }
        catch (IOException iOException) {
            return this.getName() + '=' + iOException;
        }
    }

    @Override
    protected boolean deleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    protected String getBaseDirectory() {
        return this.baseDir;
    }

    @Override
    protected String getDiskFilename() {
        return this.getName() + postfix;
    }

    @Override
    protected String getPostfix() {
        return postfix;
    }

    @Override
    protected String getPrefix() {
        return prefix;
    }

    @Override
    public Attribute copy() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.copy() : null);
    }

    @Override
    public Attribute duplicate() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.duplicate() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attribute retainedDuplicate() {
        ByteBuf byteBuf = this.content();
        if (byteBuf != null) {
            byteBuf = byteBuf.retainedDuplicate();
            boolean bl = false;
            try {
                Attribute attribute = this.replace(byteBuf);
                bl = true;
                Attribute attribute2 = attribute;
                return attribute2;
            }
            finally {
                if (!bl) {
                    byteBuf.release();
                }
            }
        }
        return this.replace(null);
    }

    @Override
    public Attribute replace(ByteBuf byteBuf) {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName(), this.baseDir, this.deleteOnExit);
        diskAttribute.setCharset(this.getCharset());
        if (byteBuf != null) {
            try {
                diskAttribute.setContent(byteBuf);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }
        diskAttribute.setCompleted(this.isCompleted());
        return diskAttribute;
    }

    @Override
    public Attribute retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public Attribute retain() {
        super.retain();
        return this;
    }

    @Override
    public Attribute touch() {
        super.touch();
        return this;
    }

    @Override
    public Attribute touch(Object object) {
        super.touch(object);
        return this;
    }

    static {
        deleteOnExitTemporaryFile = true;
    }
}

