/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler$1;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler$2;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class WebSocketServerExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
    private final Queue<List<WebSocketServerExtension>> validExtensions = new ArrayDeque<List<WebSocketServerExtension>>(4);

    public WebSocketServerExtensionHandler(WebSocketServerExtensionHandshaker ... webSocketServerExtensionHandshakerArray) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty(webSocketServerExtensionHandshakerArray, "extensionHandshakers"));
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object != LastHttpContent.EMPTY_LAST_CONTENT) {
            if (object instanceof DefaultHttpRequest) {
                this.onHttpRequestChannelRead(channelHandlerContext, (DefaultHttpRequest)object);
            } else if (object instanceof HttpRequest) {
                this.onHttpRequestChannelRead(channelHandlerContext, (HttpRequest)object);
            } else {
                super.channelRead(channelHandlerContext, object);
            }
        } else {
            super.channelRead(channelHandlerContext, object);
        }
    }

    protected void onHttpRequestChannelRead(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        String string;
        List list = null;
        if (WebSocketExtensionUtil.isWebsocketUpgrade(httpRequest.headers()) && (string = httpRequest.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS)) != null) {
            List<WebSocketExtensionData> list2 = WebSocketExtensionUtil.extractExtensions(string);
            int n = 0;
            for (WebSocketExtensionData webSocketExtensionData : list2) {
                Iterator<WebSocketServerExtensionHandshaker> iterator = this.extensionHandshakers.iterator();
                WebSocketExtension webSocketExtension = null;
                while (webSocketExtension == null && iterator.hasNext()) {
                    WebSocketServerExtensionHandshaker webSocketServerExtensionHandshaker = iterator.next();
                    webSocketExtension = webSocketServerExtensionHandshaker.handshakeExtension(webSocketExtensionData);
                }
                if (webSocketExtension == null || (webSocketExtension.rsv() & n) != 0) continue;
                if (list == null) {
                    list = new ArrayList(1);
                }
                n |= webSocketExtension.rsv();
                list.add(webSocketExtension);
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        this.validExtensions.offer(list);
        super.channelRead(channelHandlerContext, httpRequest);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object != Unpooled.EMPTY_BUFFER && !(object instanceof ByteBuf)) {
            if (object instanceof DefaultHttpResponse) {
                this.onHttpResponseWrite(channelHandlerContext, (DefaultHttpResponse)object, channelPromise);
            } else if (object instanceof HttpResponse) {
                this.onHttpResponseWrite(channelHandlerContext, (HttpResponse)object, channelPromise);
            } else {
                super.write(channelHandlerContext, object, channelPromise);
            }
        } else {
            super.write(channelHandlerContext, object, channelPromise);
        }
    }

    protected void onHttpResponseWrite(ChannelHandlerContext channelHandlerContext, HttpResponse httpResponse, ChannelPromise channelPromise) {
        List<WebSocketServerExtension> list = this.validExtensions.poll();
        HttpResponse httpResponse2 = httpResponse;
        if (HttpResponseStatus.SWITCHING_PROTOCOLS.equals(httpResponse2.status())) {
            this.handlePotentialUpgrade(channelHandlerContext, channelPromise, httpResponse2, list);
        }
        super.write(channelHandlerContext, httpResponse, channelPromise);
    }

    private void handlePotentialUpgrade(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, HttpResponse httpResponse, List<WebSocketServerExtension> list) {
        HttpHeaders httpHeaders = httpResponse.headers();
        if (WebSocketExtensionUtil.isWebsocketUpgrade(httpHeaders)) {
            if (list != null && !list.isEmpty()) {
                String string = httpHeaders.getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                for (WebSocketServerExtension webSocketServerExtension : list) {
                    arrayList.add(webSocketServerExtension.newReponseData());
                }
                String string2 = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(string, arrayList);
                channelPromise.addListener(new WebSocketServerExtensionHandler$1(this, list, channelHandlerContext));
                if (string2 != null) {
                    httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)string2);
                }
            }
            channelPromise.addListener(new WebSocketServerExtensionHandler$2(this, channelHandlerContext));
        }
    }
}

