/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.lang.reflect.Field;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSsl;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandler;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import pro.gravit.repackage.io.netty.handler.ssl.SslMasterKeyHandler$WiresharkSslMasterKeyHandler;
import pro.gravit.repackage.io.netty.util.internal.ReflectionUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class SslMasterKeyHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger;
    private static final Class<?> SSL_SESSIONIMPL_CLASS;
    private static final Field SSL_SESSIONIMPL_MASTER_SECRET_FIELD;
    public static final String SYSTEM_PROP_KEY = "pro.gravit.repackage.io.netty.ssl.masterKeyHandler";
    private static final Throwable UNAVAILABILITY_CAUSE;

    protected SslMasterKeyHandler() {
    }

    public static void ensureSunSslEngineAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw new IllegalStateException("Failed to find SSLSessionImpl on classpath", UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable sunSslEngineUnavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isSunSslEngineAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    protected abstract void accept(SecretKey var1, SSLSession var2);

    @Override
    public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object == SslHandshakeCompletionEvent.SUCCESS && this.masterKeyHandlerEnabled()) {
            SslHandler sslHandler = channelHandlerContext.pipeline().get(SslHandler.class);
            SSLEngine sSLEngine = sslHandler.engine();
            SSLSession sSLSession = sSLEngine.getSession();
            if (SslMasterKeyHandler.isSunSslEngineAvailable() && sSLSession.getClass().equals(SSL_SESSIONIMPL_CLASS)) {
                SecretKey secretKey;
                try {
                    secretKey = (SecretKey)SSL_SESSIONIMPL_MASTER_SECRET_FIELD.get(sSLSession);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Failed to access the field 'masterSecret' via reflection.", illegalAccessException);
                }
                this.accept(secretKey, sSLSession);
            } else if (OpenSsl.isAvailable() && sSLEngine instanceof ReferenceCountedOpenSslEngine) {
                SecretKeySpec secretKeySpec = ((ReferenceCountedOpenSslEngine)sSLEngine).masterKey();
                this.accept(secretKeySpec, sSLSession);
            }
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    protected boolean masterKeyHandlerEnabled() {
        return SystemPropertyUtil.getBoolean(SYSTEM_PROP_KEY, false);
    }

    public static SslMasterKeyHandler newWireSharkSslMasterKeyHandler() {
        return new SslMasterKeyHandler$WiresharkSslMasterKeyHandler();
    }

    static {
        Throwable throwable;
        logger = InternalLoggerFactory.getInstance(SslMasterKeyHandler.class);
        Class<?> clazz = null;
        Field field = null;
        try {
            clazz = Class.forName("sun.security.ssl.SSLSessionImpl");
            field = clazz.getDeclaredField("masterSecret");
            throwable = ReflectionUtil.trySetAccessible(field, true);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            if (logger.isTraceEnabled()) {
                logger.debug("sun.security.ssl.SSLSessionImpl is unavailable.", throwable2);
            }
            logger.debug("sun.security.ssl.SSLSessionImpl is unavailable: {}", (Object)throwable2.getMessage());
        }
        UNAVAILABILITY_CAUSE = throwable;
        SSL_SESSIONIMPL_CLASS = clazz;
        SSL_SESSIONIMPL_MASTER_SECRET_FIELD = field;
    }
}

