/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import pro.gravit.repackage.io.netty.util.AsciiString;
import pro.gravit.repackage.io.netty.util.NetUtil$SoMaxConnAction;
import pro.gravit.repackage.io.netty.util.NetUtilInitializations;
import pro.gravit.repackage.io.netty.util.NetUtilInitializations$NetworkIfaceAndInetAddress;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final Collection<NetworkInterface> NETWORK_INTERFACES;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    /*
     * Exception decompiling
     */
    private static Integer sysctlGetInt(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isIpV4StackPreferred() {
        return IPV4_PREFERRED;
    }

    public static boolean isIpV6AddressesPreferred() {
        return IPV6_ADDRESSES_PREFERRED;
    }

    public static byte[] createByteArrayFromIpAddressString(String string) {
        if (NetUtil.isValidIpV4Address(string)) {
            return NetUtil.validIpV4ToBytes(string);
        }
        if (NetUtil.isValidIpV6Address(string)) {
            int n;
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n = string.indexOf(37)) >= 0) {
                string = string.substring(0, n);
            }
            return NetUtil.getIPv6ByName(string, true);
        }
        return null;
    }

    public static InetAddress createInetAddressFromIpAddressString(String string) {
        if (NetUtil.isValidIpV4Address(string)) {
            byte[] byArray = NetUtil.validIpV4ToBytes(string);
            try {
                return InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException(unknownHostException);
            }
        }
        if (NetUtil.isValidIpV6Address(string)) {
            int n;
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n = string.indexOf(37)) >= 0) {
                try {
                    int n2 = Integer.parseInt(string.substring(n + 1));
                    string = string.substring(0, n);
                    byte[] byArray = NetUtil.getIPv6ByName(string, true);
                    if (byArray == null) {
                        return null;
                    }
                    try {
                        return Inet6Address.getByAddress(null, byArray, n2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalStateException(unknownHostException);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            byte[] byArray = NetUtil.getIPv6ByName(string, true);
            if (byArray == null) {
                return null;
            }
            try {
                return InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException(unknownHostException);
            }
        }
        return null;
    }

    private static int decimalDigit(String string, int n) {
        return string.charAt(n) - 48;
    }

    private static byte ipv4WordToByte(String string, int n, int n2) {
        int n3 = NetUtil.decimalDigit(string, n);
        if (++n == n2) {
            return (byte)n3;
        }
        n3 = n3 * 10 + NetUtil.decimalDigit(string, n);
        if (++n == n2) {
            return (byte)n3;
        }
        return (byte)(n3 * 10 + NetUtil.decimalDigit(string, n));
    }

    static byte[] validIpV4ToBytes(String string) {
        byte[] byArray = new byte[4];
        int n = string.indexOf(46, 1);
        byArray[0] = NetUtil.ipv4WordToByte(string, 0, n);
        int n2 = n + 1;
        n = string.indexOf(46, n + 2);
        byArray[1] = NetUtil.ipv4WordToByte(string, n2, n);
        int n3 = n + 1;
        n = string.indexOf(46, n + 2);
        byArray[2] = NetUtil.ipv4WordToByte(string, n3, n);
        byArray[3] = NetUtil.ipv4WordToByte(string, n + 1, string.length());
        return byArray;
    }

    public static int ipv4AddressToInt(Inet4Address inet4Address) {
        byte[] byArray = inet4Address.getAddress();
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static String intToIpAddress(int n) {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(n >> 24 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n >> 16 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n >> 8 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n & 0xFF);
        return stringBuilder.toString();
    }

    public static String bytesToIpAddress(byte[] byArray) {
        return NetUtil.bytesToIpAddress(byArray, 0, byArray.length);
    }

    public static String bytesToIpAddress(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 4: {
                return new StringBuilder(15).append(byArray[n] & 0xFF).append('.').append(byArray[n + 1] & 0xFF).append('.').append(byArray[n + 2] & 0xFF).append('.').append(byArray[n + 3] & 0xFF).toString();
            }
            case 16: {
                return NetUtil.toAddressString(byArray, n, false);
            }
        }
        throw new IllegalArgumentException("length: " + n2 + " (expected: 4 or 16)");
    }

    public static boolean isValidIpV6Address(String string) {
        return NetUtil.isValidIpV6Address((CharSequence)string);
    }

    public static boolean isValidIpV6Address(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 < 2) {
            return false;
        }
        char c = charSequence.charAt(0);
        if (c == '[') {
            if (charSequence.charAt(--n4) != ']') {
                return false;
            }
            n3 = 1;
            c = charSequence.charAt(1);
        } else {
            n3 = 0;
        }
        if (c == ':') {
            if (charSequence.charAt(n3 + 1) != ':') {
                return false;
            }
            n2 = 2;
            n = n3;
            n3 += 2;
        } else {
            n2 = 0;
            n = -1;
        }
        int n5 = 0;
        block5: for (int i = n3; i < n4; ++i) {
            c = charSequence.charAt(i);
            if (NetUtil.isValidHexChar(c)) {
                if (n5 < 4) {
                    ++n5;
                    continue;
                }
                return false;
            }
            switch (c) {
                case ':': {
                    if (n2 > 7) {
                        return false;
                    }
                    if (charSequence.charAt(i - 1) == ':') {
                        if (n >= 0) {
                            return false;
                        }
                        n = i - 1;
                    } else {
                        n5 = 0;
                    }
                    ++n2;
                    continue block5;
                }
                case '.': {
                    int n6;
                    if (n < 0 && n2 != 6 || n2 == 7 && n >= n3 || n2 > 7) {
                        return false;
                    }
                    int n7 = i - n5;
                    int n8 = n7 - 2;
                    if (NetUtil.isValidIPv4MappedChar(charSequence.charAt(n8))) {
                        if (!(NetUtil.isValidIPv4MappedChar(charSequence.charAt(n8 - 1)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n8 - 2)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n8 - 3)))) {
                            return false;
                        }
                        n8 -= 5;
                    }
                    while (n8 >= n3) {
                        n6 = charSequence.charAt(n8);
                        if (n6 != 48 && n6 != 58) {
                            return false;
                        }
                        --n8;
                    }
                    n6 = AsciiString.indexOf(charSequence, '%', n7 + 7);
                    if (n6 < 0) {
                        n6 = n4;
                    }
                    return NetUtil.isValidIpV4Address(charSequence, n7, n6);
                }
                case '%': {
                    n4 = i;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (n < 0) {
            return n2 == 7 && n5 > 0;
        }
        return n + 2 == n4 || n5 > 0 && (n2 < 8 || n <= n3);
    }

    private static boolean isValidIpV4Word(CharSequence charSequence, int n, int n2) {
        char c;
        int n3 = n2 - n;
        if (n3 < 1 || n3 > 3 || (c = charSequence.charAt(n)) < '0') {
            return false;
        }
        if (n3 == 3) {
            char c2;
            char c3 = charSequence.charAt(n + 1);
            return c3 >= '0' && (c2 = charSequence.charAt(n + 2)) >= '0' && (c <= '1' && c3 <= '9' && c2 <= '9' || c == '2' && c3 <= '5' && (c2 <= '5' || c3 < '5' && c2 <= '9'));
        }
        return c <= '9' && (n3 == 1 || NetUtil.isValidNumericChar(charSequence.charAt(n + 1)));
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c) {
        return c == 'f' || c == 'F';
    }

    private static boolean isValidIPv4MappedSeparators(byte by, byte by2, boolean bl) {
        return by == by2 && (by == 0 || !bl && by2 == -1);
    }

    private static boolean isValidIPv4Mapped(byte[] byArray, int n, int n2, int n3) {
        boolean bl = n2 + n3 >= 14;
        return n <= 12 && n >= 2 && (!bl || n2 < 12) && NetUtil.isValidIPv4MappedSeparators(byArray[n - 1], byArray[n - 2], bl) && PlatformDependent.isZero(byArray, 0, n - 3);
    }

    public static boolean isValidIpV4Address(CharSequence charSequence) {
        return NetUtil.isValidIpV4Address(charSequence, 0, charSequence.length());
    }

    public static boolean isValidIpV4Address(String string) {
        return NetUtil.isValidIpV4Address(string, 0, string.length());
    }

    private static boolean isValidIpV4Address(CharSequence charSequence, int n, int n2) {
        return charSequence instanceof String ? NetUtil.isValidIpV4Address((String)charSequence, n, n2) : (charSequence instanceof AsciiString ? NetUtil.isValidIpV4Address((AsciiString)charSequence, n, n2) : NetUtil.isValidIpV4Address0(charSequence, n, n2));
    }

    private static boolean isValidIpV4Address(String string, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        return n4 <= 15 && n4 >= 7 && (n3 = string.indexOf(46, n + 1)) > 0 && NetUtil.isValidIpV4Word(string, n, n3) && (n3 = string.indexOf(46, n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n - 1, n3) && (n3 = string.indexOf(46, n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n - 1, n3) && NetUtil.isValidIpV4Word(string, n3 + 1, n2);
    }

    private static boolean isValidIpV4Address(AsciiString asciiString, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        return n4 <= 15 && n4 >= 7 && (n3 = asciiString.indexOf('.', n + 1)) > 0 && NetUtil.isValidIpV4Word(asciiString, n, n3) && (n3 = asciiString.indexOf('.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n - 1, n3) && (n3 = asciiString.indexOf('.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n - 1, n3) && NetUtil.isValidIpV4Word(asciiString, n3 + 1, n2);
    }

    private static boolean isValidIpV4Address0(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        return n4 <= 15 && n4 >= 7 && (n3 = AsciiString.indexOf(charSequence, '.', n + 1)) > 0 && NetUtil.isValidIpV4Word(charSequence, n, n3) && (n3 = AsciiString.indexOf(charSequence, '.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n - 1, n3) && (n3 = AsciiString.indexOf(charSequence, '.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n - 1, n3) && NetUtil.isValidIpV4Word(charSequence, n3 + 1, n2);
    }

    public static Inet6Address getByName(CharSequence charSequence) {
        return NetUtil.getByName(charSequence, true);
    }

    public static Inet6Address getByName(CharSequence charSequence, boolean bl) {
        byte[] byArray = NetUtil.getIPv6ByName(charSequence, bl);
        if (byArray == null) {
            return null;
        }
        try {
            return Inet6Address.getByAddress(null, byArray, -1);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    static byte[] getIPv6ByName(CharSequence charSequence, boolean bl) {
        int n;
        char c;
        int n2;
        byte[] byArray = new byte[16];
        int n3 = charSequence.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        block4: for (n2 = 0; n2 < n3; ++n2) {
            c = charSequence.charAt(n2);
            switch (c) {
                case ':': {
                    if (n2 - n8 > 4 || n10 > 0 || ++n9 > 8 || n6 + 1 >= byArray.length) {
                        return null;
                    }
                    n7 <<= 4 - (n2 - n8) << 2;
                    if (n5 > 0) {
                        n5 -= 2;
                    }
                    byArray[n6++] = (byte)((n7 & 0xF) << 4 | n7 >> 4 & 0xF);
                    byArray[n6++] = (byte)((n7 >> 8 & 0xF) << 4 | n7 >> 12 & 0xF);
                    n = n2 + 1;
                    if (n < n3 && charSequence.charAt(n) == ':') {
                        if (n4 != 0 || ++n < n3 && charSequence.charAt(n) == ':') {
                            return null;
                        }
                        ++n9;
                        n4 = n6;
                        n5 = byArray.length - n4 - 2;
                        ++n2;
                    }
                    n7 = 0;
                    n8 = -1;
                    continue block4;
                }
                case '.': {
                    n = n2 - n8;
                    if (n > 3 || n8 < 0 || ++n10 > 3 || n9 > 0 && n6 + n5 < 12 || n2 + 1 >= n3 || n6 >= byArray.length || n10 == 1 && (!bl || n6 != 0 && !NetUtil.isValidIPv4Mapped(byArray, n6, n4, n5) || n == 3 && (!NetUtil.isValidNumericChar(charSequence.charAt(n2 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 2)) || !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 3))) || n == 2 && (!NetUtil.isValidNumericChar(charSequence.charAt(n2 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 2))) || n == 1 && !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 1)))) {
                        return null;
                    }
                    if ((n8 = ((n7 <<= 3 - n << 2) & 0xF) * 100 + (n7 >> 4 & 0xF) * 10 + (n7 >> 8 & 0xF)) > 255) {
                        return null;
                    }
                    byArray[n6++] = (byte)n8;
                    n7 = 0;
                    n8 = -1;
                    continue block4;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c) || n10 > 0 && !NetUtil.isValidNumericChar(c)) {
                        return null;
                    }
                    if (n8 < 0) {
                        n8 = n2;
                    } else if (n2 - n8 > 4) {
                        return null;
                    }
                    n7 += StringUtil.decodeHexNibble(c) << (n2 - n8 << 2);
                }
            }
        }
        char c2 = c = n4 > 0 ? (char)'\u0001' : '\u0000';
        if (n10 > 0) {
            if (n8 > 0 && n2 - n8 > 3 || n10 != 3 || n6 >= byArray.length) {
                return null;
            }
            if (n9 != 0 && (n9 < 2 || (c != '\u0000' || n9 != 6 || charSequence.charAt(0) == ':') && (c == '\u0000' || n9 >= 8 || charSequence.charAt(0) == ':' && n4 > 2))) {
                return null;
            }
            if ((n8 = ((n7 <<= 3 - (n2 - n8) << 2) & 0xF) * 100 + (n7 >> 4 & 0xF) * 10 + (n7 >> 8 & 0xF)) > 255) {
                return null;
            }
            byArray[n6++] = (byte)n8;
        } else {
            n = n3 - 1;
            if (n8 > 0 && n2 - n8 > 4 || n9 < 2 || c == '\u0000' && (n9 + 1 != 8 || charSequence.charAt(0) == ':' || charSequence.charAt(n) == ':') || c != '\u0000' && (n9 > 8 || n9 == 8 && (n4 <= 2 && charSequence.charAt(0) != ':' || n4 >= 14 && charSequence.charAt(n) != ':')) || n6 + 1 >= byArray.length || n8 < 0 && charSequence.charAt(n - 1) != ':' || n4 > 2 && charSequence.charAt(0) == ':') {
                return null;
            }
            if (n8 >= 0 && n2 - n8 <= 4) {
                n7 <<= 4 - (n2 - n8) << 2;
            }
            byArray[n6++] = (byte)((n7 & 0xF) << 4 | n7 >> 4 & 0xF);
            byArray[n6++] = (byte)((n7 >> 8 & 0xF) << 4 | n7 >> 12 & 0xF);
        }
        if (n6 < byArray.length) {
            int n11 = n6 - n4;
            int n12 = byArray.length - n11;
            System.arraycopy(byArray, n4, byArray, n12, n11);
            Arrays.fill(byArray, n4, n12, (byte)0);
        }
        if (n10 > 0) {
            byArray[11] = -1;
            byArray[10] = -1;
        }
        return byArray;
    }

    public static String toSocketAddressString(InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder;
        String string = String.valueOf(inetSocketAddress.getPort());
        if (inetSocketAddress.isUnresolved()) {
            String string2;
            stringBuilder = NetUtil.newSocketAddressStringBuilder(string2, string, !NetUtil.isValidIpV6Address(string2 = NetUtil.getHostname(inetSocketAddress)));
        } else {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            String string3 = NetUtil.toAddressString(inetAddress);
            stringBuilder = NetUtil.newSocketAddressStringBuilder(string3, string, inetAddress instanceof Inet4Address);
        }
        return stringBuilder.append(':').append(string).toString();
    }

    public static String toSocketAddressString(String string, int n) {
        String string2 = String.valueOf(n);
        return NetUtil.newSocketAddressStringBuilder(string, string2, !NetUtil.isValidIpV6Address(string)).append(':').append(string2).toString();
    }

    private static StringBuilder newSocketAddressStringBuilder(String string, String string2, boolean bl) {
        int n = string.length();
        if (bl) {
            return new StringBuilder(n + 1 + string2.length()).append(string);
        }
        StringBuilder stringBuilder = new StringBuilder(n + 3 + string2.length());
        if (n > 1 && string.charAt(0) == '[' && string.charAt(n - 1) == ']') {
            return stringBuilder.append(string);
        }
        return stringBuilder.append('[').append(string).append(']');
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl) {
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress);
        }
        return NetUtil.toAddressString(inetAddress.getAddress(), 0, bl);
    }

    private static String toAddressString(byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[8];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            n3 = (n4 << 1) + n;
            nArray[n4] = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
        }
        n4 = -1;
        int n5 = -1;
        int n6 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 0) {
                if (n4 >= 0) continue;
                n4 = n2;
                continue;
            }
            if (n4 < 0) continue;
            n3 = n2 - n4;
            if (n3 > n6) {
                n5 = n4;
                n6 = n3;
            }
            n4 = -1;
        }
        if (n4 >= 0 && (n3 = nArray.length - n4) > n6) {
            n5 = n4;
            n6 = n3;
        }
        if (n6 == 1) {
            n6 = 0;
            n5 = -1;
        }
        n2 = n5 + n6;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n2 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (int i = 1; i < nArray.length; ++i) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[i]));
            }
        } else {
            boolean bl2;
            if (NetUtil.inRangeEndExclusive(0, n5, n2)) {
                stringBuilder.append("::");
                bl2 = bl && n2 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl2 = false;
            }
            for (int i = 1; i < nArray.length; ++i) {
                if (!NetUtil.inRangeEndExclusive(i, n5, n2)) {
                    if (!NetUtil.inRangeEndExclusive(i - 1, n5, n2)) {
                        if (!bl2 || i == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl2 && i > 5) {
                        stringBuilder.append(nArray[i] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[i] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[i]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(i - 1, n5, n2)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    public static String getHostname(InetSocketAddress inetSocketAddress) {
        return PlatformDependent.javaVersion() >= 7 ? inetSocketAddress.getHostString() : inetSocketAddress.getHostName();
    }

    private static boolean inRangeEndExclusive(int n, int n2, int n3) {
        return n >= n2 && n < n3;
    }

    private NetUtil() {
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }

    static /* synthetic */ Integer access$200(String string) {
        return NetUtil.sysctlGetInt(string);
    }

    static {
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        String string = SystemPropertyUtil.get("java.net.preferIPv6Addresses", "false");
        IPV6_ADDRESSES_PREFERRED = "true".equalsIgnoreCase(string.trim());
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", (Object)string);
        NETWORK_INTERFACES = NetUtilInitializations.networkInterfaces();
        LOCALHOST4 = NetUtilInitializations.createLocalhost4();
        LOCALHOST6 = NetUtilInitializations.createLocalhost6();
        NetUtilInitializations$NetworkIfaceAndInetAddress netUtilInitializations$NetworkIfaceAndInetAddress = NetUtilInitializations.determineLoopback(NETWORK_INTERFACES, LOCALHOST4, LOCALHOST6);
        LOOPBACK_IF = netUtilInitializations$NetworkIfaceAndInetAddress.iface();
        LOCALHOST = netUtilInitializations$NetworkIfaceAndInetAddress.address();
        SOMAXCONN = AccessController.doPrivileged(new NetUtil$SoMaxConnAction(null));
    }
}

