/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.util.ArrayDeque;
import pro.gravit.repackage.io.netty.util.Recycler;
import pro.gravit.repackage.io.netty.util.Recycler$BlockingMessageQueue;
import pro.gravit.repackage.io.netty.util.Recycler$DefaultHandle;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocalThread;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;

final class Recycler$LocalPool<T>
implements MessagePassingQueue$Consumer<Recycler$DefaultHandle<T>> {
    private final int ratioInterval;
    private final int chunkSize;
    private final ArrayDeque<Recycler$DefaultHandle<T>> batch;
    private volatile Thread owner;
    private volatile MessagePassingQueue<Recycler$DefaultHandle<T>> pooledHandles;
    private int ratioCounter;

    Recycler$LocalPool(int n, int n2, int n3) {
        this.ratioInterval = n2;
        this.chunkSize = n3;
        this.batch = new ArrayDeque(n3);
        Thread thread = Thread.currentThread();
        this.owner = !Recycler.access$700() || thread instanceof FastThreadLocalThread ? thread : null;
        this.pooledHandles = Recycler.access$800() ? new Recycler$BlockingMessageQueue<Recycler$DefaultHandle<T>>(n) : (MessagePassingQueue)((Object)PlatformDependent.newMpscQueue(n3, n));
        this.ratioCounter = n2;
    }

    Recycler$DefaultHandle<T> claim() {
        Recycler$DefaultHandle<T> recycler$DefaultHandle;
        MessagePassingQueue<Recycler$DefaultHandle<T>> messagePassingQueue = this.pooledHandles;
        if (messagePassingQueue == null) {
            return null;
        }
        if (this.batch.isEmpty()) {
            messagePassingQueue.drain(this, this.chunkSize);
        }
        if (null != (recycler$DefaultHandle = this.batch.pollFirst())) {
            recycler$DefaultHandle.toClaimed();
        }
        return recycler$DefaultHandle;
    }

    void release(Recycler$DefaultHandle<T> recycler$DefaultHandle, boolean bl) {
        if (bl) {
            recycler$DefaultHandle.toAvailable();
        } else {
            recycler$DefaultHandle.unguardedToAvailable();
        }
        Thread thread = this.owner;
        if (thread != null && Thread.currentThread() == thread && this.batch.size() < this.chunkSize) {
            this.accept(recycler$DefaultHandle);
        } else if (thread != null && Recycler$LocalPool.isTerminated(thread)) {
            this.owner = null;
            this.pooledHandles = null;
        } else {
            MessagePassingQueue<Recycler$DefaultHandle<Recycler$DefaultHandle<T>>> messagePassingQueue = this.pooledHandles;
            if (messagePassingQueue != null) {
                messagePassingQueue.relaxedOffer(recycler$DefaultHandle);
            }
        }
    }

    private static boolean isTerminated(Thread thread) {
        return PlatformDependent.isJ9Jvm() ? !thread.isAlive() : thread.getState() == Thread.State.TERMINATED;
    }

    Recycler$DefaultHandle<T> newHandle() {
        if (++this.ratioCounter >= this.ratioInterval) {
            this.ratioCounter = 0;
            return new Recycler$DefaultHandle(this);
        }
        return null;
    }

    @Override
    public void accept(Recycler$DefaultHandle<T> recycler$DefaultHandle) {
        this.batch.addLast(recycler$DefaultHandle);
    }

    static /* synthetic */ MessagePassingQueue access$400(Recycler$LocalPool recycler$LocalPool) {
        return recycler$LocalPool.pooledHandles;
    }

    static /* synthetic */ MessagePassingQueue access$402(Recycler$LocalPool recycler$LocalPool, MessagePassingQueue messagePassingQueue) {
        recycler$LocalPool.pooledHandles = messagePassingQueue;
        return recycler$LocalPool.pooledHandles;
    }

    static /* synthetic */ Thread access$502(Recycler$LocalPool recycler$LocalPool, Thread thread) {
        recycler$LocalPool.owner = thread;
        return recycler$LocalPool.owner;
    }

    static /* synthetic */ ArrayDeque access$600(Recycler$LocalPool recycler$LocalPool) {
        return recycler$LocalPool.batch;
    }
}

