/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import pro.gravit.utils.command.BaseCommandCategory;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.command.CommandHandler$Category;
import pro.gravit.utils.command.CommandHandler$CommandWalk;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public abstract class CommandHandler
implements Runnable {
    private final List<CommandHandler$Category> categories = new ArrayList<CommandHandler$Category>();
    private final CommandCategory baseCategory = new BaseCommandCategory();

    public void eval(String string, boolean bl) {
        LogHelper.info("Command '%s'", string);
        try {
            this.evalNative(string, bl);
        }
        catch (Exception exception) {
            LogHelper.error(exception);
        }
    }

    public void evalNative(String string, boolean bl) {
        String[] stringArray = CommonHelper.parseCommand(string);
        if (stringArray.length > 0) {
            stringArray[0] = stringArray[0].toLowerCase();
        }
        this.eval(stringArray, bl);
    }

    public void eval(String[] stringArray, boolean bl) {
        if (stringArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        this.lookup(stringArray[0]).invoke(Arrays.copyOfRange(stringArray, 1, stringArray.length));
        long l2 = System.currentTimeMillis();
        if (bl && l2 - l >= 5000L) {
            this.bell();
        }
    }

    public Command lookup(String string) {
        Command command = this.findCommand(string);
        if (command == null) {
            throw new CommandException(String.format("Unknown command: '%s'", string));
        }
        return command;
    }

    public Command findCommand(String string) {
        Command command = this.baseCategory.findCommand(string);
        if (command == null) {
            for (CommandHandler$Category commandHandler$Category : this.categories) {
                command = commandHandler$Category.category.findCommand(string);
                if (command == null) continue;
                return command;
            }
        }
        return command;
    }

    public abstract String readLine();

    private void readLoop() {
        String string = this.readLine();
        while (string != null) {
            this.eval(string, true);
            string = this.readLine();
        }
    }

    public void registerCommand(String string, Command command) {
        this.baseCategory.registerCommand(string, command);
    }

    public void registerCategory(CommandHandler$Category commandHandler$Category) {
        this.categories.add(commandHandler$Category);
    }

    public void unregisterCategory(CommandHandler$Category commandHandler$Category) {
        this.categories.remove(commandHandler$Category);
    }

    public CommandHandler$Category findCategory(String string) {
        for (CommandHandler$Category commandHandler$Category : this.categories) {
            if (!commandHandler$Category.name.equals(string)) continue;
            return commandHandler$Category;
        }
        return null;
    }

    public Command unregisterCommand(String string) {
        return this.baseCategory.unregisterCommand(string);
    }

    @Override
    public void run() {
        try {
            this.readLoop();
        }
        catch (IOException iOException) {
            LogHelper.error(iOException);
        }
    }

    public void walk(CommandHandler$CommandWalk commandHandler$CommandWalk) {
        for (CommandHandler$Category object : this.getCategories()) {
            for (Map.Entry<String, Command> entry : object.category.commandsMap().entrySet()) {
                commandHandler$CommandWalk.walk(object, entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : this.getBaseCategory().commandsMap().entrySet()) {
            commandHandler$CommandWalk.walk(null, (String)entry.getKey(), (Command)entry.getValue());
        }
    }

    public CommandCategory getBaseCategory() {
        return this.baseCategory;
    }

    public List<CommandHandler$Category> getCategories() {
        return this.categories;
    }

    public abstract void bell();

    public abstract void clear();
}

